within PVSystems.UsersGuide;
package ReleaseNotes "Release notes"
extends Modelica.Icons.ReleaseNotes;



annotation (Documentation(info="<html>
      <p>
        This section includes an item per release, indicating version
        number and release date. Release notes are included under each
        corresponding item.
      </p>
    
      <p>
        <a href=\"http://semver.org/\">Semantic Versioning</a> is followed
        to establish version numbers. Given a version number
        MAJOR.MINOR.PATCH, an increment in the:
      </p>
      <ul class=\"org-ul\">
        <li>MAJOR version indicates incompatible API changes.
        </li>
        <li>MINOR version indicates new functionality in a
          backwards-compatible manner.
        </li>
        <li>PATCH version indicates backwards-compatible bug fixes.
        </li>
      </ul>
    
      <p>
        Notice, though, that major version zero (0.y.z) is for initial
        development - anything may change at any time and the public API
        should not be considered stable.</p>
    </html>"));
end ReleaseNotes;
